
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <unistd.h>

#define SHM_SIZE 1

union semun {
    int val;               /* used for SETVAL only */
    struct semid_ds *buf;  /* used for IPC_STAT and IPC_SET */
    ushort *array;         /* used for GETALL and SETALL */
};

int main(int argc, char *argv[])
{
    key_t key;
    int shmid, semid;
    int *data;
    union semun arg;

    /* pravi kljuc */
    key = ftok("./shmem1.c", 'R');
	printf("Kljuc je %d\n", key);

    /* kreiranje segmenta */
    shmid = shmget(key, SHM_SIZE*sizeof(int), 0644 | IPC_CREAT);
    printf("ID segmenta je %d\n", shmid);
    
    /* pravi kljuc za semafor */
    key = ftok("./shmem1.c", 'A');
	printf("Kljuc je %d\n", key);
    
    /* kreiranje semafora */
    semid = semget(key, 1, 0644 | IPC_CREAT);
    printf("ID skupa semafora je %d\n", semid);

    /* prikaci segment da bi dobio pokazivac na njega */
    data = shmat(shmid, NULL, 0);

    /* inicijalizacija */
    arg.val = 1;
    semctl(semid, 0, SETVAL, arg);

    *data = 5;
    printf("Deljena memorija: %d\n", *data);

	sleep(30);
	
	printf("Deljena memorija: %d\n", *data);

    /* odvaja se od segmenta */
    shmdt(data);

    return 0;
}
